/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.items;

import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.Constants;
import net.dries007.tfc.api.capability.size.Size;
import net.dries007.tfc.api.capability.size.Weight;
import net.dries007.tfc.api.registries.TFCRegistries;
import net.dries007.tfc.api.types.Ore;
import net.dries007.tfc.api.types.Rock;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.objects.items.ItemTFC;
import net.dries007.tfc.objects.items.metal.ItemSmallOre;
import net.dries007.tfc.objects.items.rock.ItemRock;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.OreDictionaryHelper;
import net.dries007.tfc.world.classic.chunkdata.ChunkDataTFC;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ItemGoldPan
extends ItemTFC {
    public static final String[] TYPES = new String[]{"empty", "sand", "gravel", "clay", "dirt"};

    public ItemGoldPan() {
        this.func_77656_e(0);
        this.func_77625_d(1);
        this.setNoRepair();
        this.func_77627_a(true);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (hand != EnumHand.MAIN_HAND || player.func_184587_cr()) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
        }
        if (player.func_70093_af()) {
            if (stack.func_77952_i() > 0) {
                stack.func_77964_b(0);
                return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
            }
            return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
        }
        RayTraceResult result = this.func_77621_a(world, player, true);
        if (result == null || result.field_72313_a != RayTraceResult.Type.BLOCK) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
        }
        if (stack.func_77952_i() > 0 && world.func_180495_p(result.func_178782_a()).func_185904_a() == Material.field_151586_h) {
            player.func_184598_c(hand);
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (hand != EnumHand.MAIN_HAND) {
            return EnumActionResult.PASS;
        }
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77952_i() > 0) {
            if (world.func_180495_p(pos.func_177972_a(facing)).func_185904_a() == Material.field_151586_h) {
                player.func_184598_c(hand);
                return EnumActionResult.SUCCESS;
            }
            return EnumActionResult.PASS;
        }
        IBlockState state = world.func_180495_p(pos);
        ItemStack stackAt = new ItemStack(Item.func_150898_a((Block)state.func_177230_c()));
        if (OreDictionaryHelper.doesStackMatchOre(stackAt, "sand")) {
            stack.func_77964_b(1);
        } else if (OreDictionaryHelper.doesStackMatchOre(stackAt, "gravel")) {
            stack.func_77964_b(2);
        } else if (OreDictionaryHelper.doesStackMatchOre(stackAt, "blockClayDirt") || OreDictionaryHelper.doesStackMatchOre(stackAt, "blockClayGrass")) {
            stack.func_77964_b(3);
        } else if (OreDictionaryHelper.doesStackMatchOre(stackAt, "dirt") || OreDictionaryHelper.doesStackMatchOre(stackAt, "grass")) {
            stack.func_77964_b(4);
        }
        return EnumActionResult.SUCCESS;
    }

    @Nonnull
    public ItemStack func_77654_b(@Nonnull ItemStack stack, World world, EntityLivingBase entityLiving) {
        if (entityLiving instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entityLiving;
            if (stack.func_77952_i() > 0) {
                RayTraceResult result = this.func_77621_a(world, player, true);
                if (result == null || result.field_72313_a != RayTraceResult.Type.BLOCK) {
                    return stack;
                }
                BlockPos pos = result.func_178782_a();
                if (world.func_180495_p(pos).func_185904_a() == Material.field_151586_h) {
                    int damage = stack.func_77952_i();
                    BlockPos position = player.func_180425_c();
                    if (!world.field_72995_K) {
                        Chunk chunk = world.func_175726_f(position);
                        ChunkDataTFC chunkDataTFC = ChunkDataTFC.get(chunk);
                        if (chunkDataTFC.canWork(6)) {
                            if (damage == 1 || damage == 2) {
                                Random rand = new Random(world.func_72905_C() + (long)chunk.func_76632_l().field_77276_a * 241179128412L + (long)chunk.func_76632_l().field_77275_b * 327910215471L);
                                TFCRegistries.ORES.getValuesCollection().stream().filter(Ore::canPan).filter(x -> rand.nextDouble() < x.getChunkChance()).forEach(x -> {
                                    if (Constants.RNG.nextDouble() < x.getPanChance()) {
                                        Helpers.spawnItemStack(world, position, new ItemStack((Item)ItemSmallOre.get(x)));
                                    }
                                });
                            } else if (damage == 3 || damage == 4) {
                                Rock rock = chunkDataTFC.getRockHeight(position);
                                if (Constants.RNG.nextDouble() < 0.35) {
                                    Helpers.spawnItemStack(world, position, new ItemStack((Item)ItemRock.get(rock), 1));
                                } else if (damage == 3 && Constants.RNG.nextDouble() < 0.1) {
                                    Helpers.spawnItemStack(world, position, new ItemStack(Items.field_151103_aS, 1));
                                } else if (damage != 3 && Constants.RNG.nextDouble() < 0.1) {
                                    Helpers.spawnItemStack(world, position, new ItemStack(Items.field_151055_y, 1));
                                }
                            }
                            chunkDataTFC.addWork(6);
                        } else {
                            player.func_145747_a((ITextComponent)new TextComponentTranslation("tfc.tooltip.goldpan.chunkworked", new Object[0]));
                        }
                    }
                    stack.func_77964_b(0);
                    if ((double)Constants.RNG.nextFloat() < 0.01) {
                        stack.func_190918_g(1);
                        world.func_184133_a(null, entityLiving.func_180425_c(), TFCSounds.CERAMIC_BREAK, SoundCategory.PLAYERS, 1.0f, 1.0f);
                    } else {
                        player.func_184811_cZ().func_185145_a(stack.func_77973_b(), ConfigTFC.Devices.GOLD_PAN.cooldownTicks);
                    }
                }
            }
        }
        return stack;
    }

    public String func_77667_c(ItemStack stack) {
        return super.func_77667_c(stack) + "." + TYPES[stack.func_77952_i()];
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    public int func_77626_a(ItemStack stack) {
        return 54;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            for (int meta = 0; meta < TYPES.length; ++meta) {
                items.add((Object)new ItemStack((Item)this, 1, meta));
            }
        }
    }

    @Override
    @Nonnull
    public Size getSize(ItemStack stack) {
        return Size.NORMAL;
    }

    @Override
    @Nonnull
    public Weight getWeight(ItemStack stack) {
        return Weight.MEDIUM;
    }

    @Override
    public boolean canStack(ItemStack stack) {
        return false;
    }
}

